

DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `server_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  `comment` varchar(512) NOT NULL,
  `date_added` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `favorites`;

CREATE TABLE `favorites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `pages` (`page_id`, `title`, `url`, `description`)
VALUES
	(1,'Terms of Service','terms-of-service1','<p>&nbsp;</p>\r\n<p>Your terms of service go <strong>here</strong>..</p>'),
	(3,'Contact','contact','<p>Contact info..</p>'),
	(4,'Refund Policy','refund-policy','<p>Refund policy here..</p>');


DROP TABLE IF EXISTS `payments`;

CREATE TABLE `payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `highlighted_days` int(11) NOT NULL,
  `date` varchar(32) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `revenue` int(11) NOT NULL,
  `email` varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `points`;

CREATE TABLE `points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `ip` varchar(32) NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `reports`;

CREATE TABLE `reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(128) NOT NULL DEFAULT '',
  `type` int(11) NOT NULL,
  `reported_id` int(11) NOT NULL,
  `message` varchar(512) NOT NULL,
  `date` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


DROP TABLE IF EXISTS `servers`;

CREATE TABLE `servers` (
  `server_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `address` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `connection_port` int(11) NOT NULL,
  `query_port` int(11) NOT NULL,
  `private` int(11) NOT NULL DEFAULT '1',
  `active` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(2560) COLLATE utf8_unicode_ci NOT NULL,
  `website` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT '',
  `youtube_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `date_added` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `highlight` int(11) NOT NULL DEFAULT '0',
  `votes` int(11) NOT NULL DEFAULT '0',
  `favorites` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `online_players` int(11) NOT NULL DEFAULT '0',
  `maximum_online_players` int(11) NOT NULL DEFAULT '0',
  `hostname` varchar(256) COLLATE utf8_unicode_ci DEFAULT '',
  `gametype` varchar(256) COLLATE utf8_unicode_ci DEFAULT '',
  `details` mediumtext COLLATE utf8_unicode_ci,
  `players` mediumtext COLLATE utf8_unicode_ci,
  `cachetime` varchar(16) COLLATE utf8_unicode_ci DEFAULT '',
  `uptime_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `downtime` int(11) NOT NULL DEFAULT '0',
  `type` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `joinlink` varchar(256) COLLATE utf8_unicode_ci DEFAULT '',
  `map` varchar(256) COLLATE utf8_unicode_ci DEFAULT '',
  `password` int(11) DEFAULT '0',
  PRIMARY KEY (`server_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


DROP TABLE IF EXISTS `settings`;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `title` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_description` varchar(1024) COLLATE utf8_unicode_ci DEFAULT NULL,
  `banned_words` varchar(2560) COLLATE utf8_unicode_ci DEFAULT NULL,
  `analytics_code` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_confirmation` int(11) DEFAULT '0',
  `guest_submit` int(11) DEFAULT '0',
  `servers_pagination` int(11) DEFAULT '10',
  `avatar_max_size` int(11) DEFAULT '250000',
  `cover_max_size` int(11) DEFAULT '300000',
  `contact_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cache_reset_time` int(11) DEFAULT NULL,
  `display_offline_servers` int(11) DEFAULT '1',
  `new_servers_visibility` int(11) DEFAULT NULL,
  `top_ads` varchar(2560) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bottom_ads` varchar(2560) COLLATE utf8_unicode_ci DEFAULT NULL,
  `server_ads` varchar(2560) COLLATE utf8_unicode_ci DEFAULT NULL,
  `public_key` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private_key` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sharethis_pub_id` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paypal_email` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_currency` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `maximum_slots` int(11) DEFAULT NULL,
  `per_day_cost` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `minimum_days` int(11) DEFAULT NULL,
  `maximum_days` int(11) DEFAULT NULL,
  `facebook` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `twitter` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `googleplus` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL,
  `smtp_host` text COLLATE utf8_unicode_ci,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_user` text COLLATE utf8_unicode_ci,
  `smtp_pass` text CHARACTER SET utf8,
  `description` varchar(512) COLLATE utf8_unicode_ci DEFAULT NULL,
  `new_guest_servers_status` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `settings` (`id`, `title`, `url`, `meta_description`, `banned_words`, `analytics_code`, `email_confirmation`, `guest_submit`, `servers_pagination`, `avatar_max_size`, `cover_max_size`, `contact_email`, `cache_reset_time`, `display_offline_servers`, `new_servers_visibility`, `top_ads`, `bottom_ads`, `server_ads`, `public_key`, `private_key`, `sharethis_pub_id`, `paypal_email`, `payment_currency`, `maximum_slots`, `per_day_cost`, `minimum_days`, `maximum_days`, `facebook`, `twitter`, `googleplus`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `description`, `new_guest_servers_status`)
VALUES
	(1,'phpServersList','http://localhost/phpMyServersList/','','','',1,0,10,1000000,1000000,'no-reply@domain.com',600,1,1,'','','Check out my Twitter <a href=\"https://twitter.com/grohsfabian\">@grohsfabian</a><br />\r\nRemove this from admin panel.','6LfYLQwTAAAAAEFYRYDpXnXYr-YjWz68ZSAi73cv','6LfYLQwTAAAAAIhXCGzJ9cJ5O8OUWEqdUxOAqbhP','23f06003-6259-4f2f-a68a-fb390740ecda','','USD',4,'5',1,5,'','grohsfabian','','',0,'','','Just a random description of the website right here',0);


DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `password` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `email_activation_code` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `lost_password_code` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `name` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `about` varchar(128) COLLATE utf8_unicode_ci DEFAULT '',
  `website` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `location` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `avatar` varchar(38) COLLATE utf8_unicode_ci DEFAULT '',
  `cover` varchar(38) COLLATE utf8_unicode_ci DEFAULT '',
  `facebook` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `twitter` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `googleplus` varchar(64) COLLATE utf8_unicode_ci DEFAULT '',
  `type` int(11) NOT NULL DEFAULT '0',
  `active` int(11) NOT NULL DEFAULT '0',
  `private` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `date` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `last_activity` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `users` (`user_id`, `password`, `email`, `email_activation_code`, `lost_password_code`, `name`, `about`, `website`, `location`, `avatar`, `cover`, `facebook`, `twitter`, `googleplus`, `type`, `active`, `private`, `ip`, `date`, `last_activity`)
VALUES
	(1,'ce4a140c729f412deb4dbcbc023397e6f2ac06bfc45b679a41c17e975d7f1fb9bfc3bc0d37480140fa22d35db9facf3f55a0dcd83f98fbe0360e1f0a90a434e1','admin@admin.com','','0','Admin','','http://grohsfabian.com','','','','test','test','test',2,1,1,'-hax-','-hax-','1492594820')

